﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using DataAccess;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using ext = Ext.Net;

/// <summary>
/// Handles loading the applications menu and tool bar
/// </summary>
public class CAppMenu2
{

    protected BaseMaster m_BaseMstr;
    protected long m_AppID { get; set; }
    public string IconsPath { get; set; }
    protected DataSet m_AllMenuItems { get; set; }

    protected string strScheme { set; get; }
    protected string strAuthority { set; get; }
    protected string strAppPath { set; get; }
    protected string strMenuPath { set; get; }

    /// <summary>
    /// Constructor
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="targetPage"></param>
    /// <param name="AppID"></param>
    public CAppMenu2(BaseMaster BaseMstr, Page targetPage, long AppID)
    {
        m_BaseMstr = BaseMstr;
        m_AppID = AppID;

        strScheme = targetPage.Request.Url.Scheme;
        strAuthority = targetPage.Request.Url.Authority;
        strAppPath = targetPage.Request.ApplicationPath;

        strMenuPath = strScheme + "://" + strAuthority + strAppPath + "/";
    }

    /// <summary>
    /// Get Root Level Menu Items
    /// </summary>
    /// <returns></returns>
    protected DataSet GetRootLevelItemsDS()
    {
        DataSet ds = null;
        if (m_AllMenuItems != null)
        {
            ds = new DataSet();
            ds.Tables.Add(m_AllMenuItems.Tables[0].Clone());
            DataRow[] drRoot = m_AllMenuItems.Tables[0].Select("PARENT_ITEM = 0");
            foreach (DataRow dr in drRoot)
            {
                DataRow drNew = ds.Tables[0].NewRow();
                foreach (DataColumn dc in ds.Tables[0].Columns)
                {
                    drNew[dc.ColumnName] = dr[dc.ColumnName];
                }
                ds.Tables[0].Rows.Add(drNew);
            }
        }
        return ds;
    }

    /// <summary>
    /// Get Child Menu Items
    /// </summary>
    /// <param name="lItemID"></param>
    /// <returns></returns>
    protected DataSet GetMenuChildItemsDS(long lItemID)
    {
        DataSet ds = null;
        if (m_AllMenuItems != null)
        {
            ds = new DataSet();
            ds.Tables.Add(m_AllMenuItems.Tables[0].Clone());
            DataRow[] drRoot = m_AllMenuItems.Tables[0].Select("PARENT_ITEM = " + lItemID.ToString());
            foreach (DataRow dr in drRoot)
            {
                DataRow drNew = ds.Tables[0].NewRow();
                foreach (DataColumn dc in ds.Tables[0].Columns)
                {
                    drNew[dc.ColumnName] = dr[dc.ColumnName];
                }
                ds.Tables[0].Rows.Add(drNew);
            }
        }
        return ds;
    }

    /// <summary>
    /// Get Toolbar Items
    /// </summary>
    /// <returns></returns>
    protected DataSet GetToolbarItemsDS()
    {
        //status info
        long lStatusCode = 0;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_APP_MENU2.GetToolbarItemsRS",
                                            pList,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Build the Toolbar's HTML string
    /// </summary>
    /// <returns></returns>
    public string RenderToolbarHTML()
    {
        String strHTML = String.Empty;
        DataSet dsToolbarItems = GetToolbarItemsDS();

        bool bSelectedPatient = (!String.IsNullOrEmpty(m_BaseMstr.SelectedPatientID));
        //bool bSelectedEncounter = (!String.IsNullOrEmpty(m_BaseMstr.SelectedEncounterID));
        bool bSelectedEncounter = true;
        bool bHasOpenCase = false;
        bool bTIU = m_BaseMstr.APPMaster.TIU;
        bool bIgnoreOnTIU = false;

        if (bSelectedPatient)
        {
            bHasOpenCase = m_BaseMstr.APPMaster.PatientHasOpenCase;
        }

        if (!CDataUtils2.IsEmpty(dsToolbarItems))
        {
            if (dsToolbarItems.Tables[0].Rows.Count > 0)
            {
                foreach (DataTable dt in dsToolbarItems.Tables)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        bool bItmSelectedPatient = false;
                        bool bItmSelectedEncounter = false;
                        bool bItmHasOpenCase = false;
                        bool bCheckPatLock = false;


                        string strToolbarItm = String.Empty;

                        string strHTMLProperty = String.Empty;
                        string strJSProperty = String.Empty;
                        string strTitle = String.Empty;
                        string strImgSrc = String.Empty;
                        string strWidth = String.Empty;
                        string strHeight = String.Empty;
                        string strClosesPatient = String.Empty;

                        bItmSelectedPatient = (Convert.ToInt32(dr["SELECTED_PATIENT"]) > 0);
                        bItmSelectedEncounter = (Convert.ToInt32(dr["SELECTED_ENCOUNTER"]) > 0);
                        bItmHasOpenCase = (Convert.ToInt32(dr["HAS_OPEN_CASE"]) > 0);
                        bCheckPatLock = (Convert.ToInt32(dr["CHECK_PAT_LOCK"]) > 0);

                        bool bClosesPatient = (Convert.ToInt32(dr["CLOSES_PATIENT"]) == 1 && Convert.ToInt32(dr["HAS_CHILDREN"]) == 0);

                        if (!dr.IsNull("IGNORE_ON_TIU"))
                        {
                            bIgnoreOnTIU = Convert.ToInt32(dr["IGNORE_ON_TIU"]) > 0;
                        }

                        if (!dr.IsNull("HTML_PROPERTY"))
                        {
                            strHTMLProperty = dr["HTML_PROPERTY"].ToString();
                        }

                        if (!dr.IsNull("JS_PROPERTY"))
                        {
                            strJSProperty = dr["JS_PROPERTY"].ToString();
                        }

                        if (!dr.IsNull("TITLE"))
                        {
                            strTitle = dr["TITLE"].ToString();
                        }

                        if (!dr.IsNull("IMG_SRC"))
                        {
                            strImgSrc = dr["IMG_SRC"].ToString();
                        }

                        if (!dr.IsNull("WIDTH"))
                        {
                            strWidth = dr["WIDTH"].ToString();
                        }

                        if (!dr.IsNull("HEIGHT"))
                        {
                            strHeight = dr["HEIGHT"].ToString();
                        }

                        if (bClosesPatient)
                        {
                            strClosesPatient = " CLOSES_PATIENT = \"CLOSES_PATIENT\" ";
                        }


                        strToolbarItm += "<div class=\"tbIcon\" " + strJSProperty + " " + strHTMLProperty + " " + strClosesPatient + ">";
                        strToolbarItm += "  <table cellpadding=\"0\" cellspacing=\"0\" width=\"" + strWidth + "\" style=\"margin: 0;\">";
                        strToolbarItm += "      <tr>";
                        strToolbarItm += "          <td height=\"" + strHeight + "\" valign=\"middle\" align=\"center\">";
                        strToolbarItm += "              <img alt=\"" + strTitle + "\" title=\"" + strTitle + "\" ";
                        strToolbarItm += "              src=\"" + strImgSrc + "\" width=\"" + strWidth + "\" height=\"" + strHeight + "\" />";
                        strToolbarItm += "          </td>";
                        strToolbarItm += "      </tr>";
                        strToolbarItm += "  </table>";
                        strToolbarItm += "</div>";

                        if (!bItmHasOpenCase || bHasOpenCase)
                        {
                            // check if the menu item requires a selected patient
                            // if there is no selected patient the menu item is ignored
                            // if there is a selected patient, replace the patient place holder string ~%P~
                            if (bItmSelectedPatient && !bSelectedPatient)
                            {
                                strToolbarItm = String.Empty;
                            }

                            if (bItmSelectedPatient && bSelectedPatient)
                            {
                                strToolbarItm = strToolbarItm.Replace("~%P~", m_BaseMstr.SelectedPatientID);
                                //strToolbarItm = strToolbarItm.Replace("~%T~", m_BaseMstr.SelectedTreatmentID.ToString());
                                strToolbarItm = strToolbarItm.Replace("~%T~", String.Empty);
                            }

                            // check if the menu item requires a selected encounter
                            // if there is no selected encounter the menu item is ignored
                            // if there is a selected encounter, replace the encounter place holder string ~%E~
                            if (bItmSelectedEncounter && !bSelectedEncounter)
                            {
                                strToolbarItm = String.Empty;
                            }

                            if (bItmSelectedEncounter && bSelectedEncounter)
                            {
                                //strToolbarItm = strToolbarItm.Replace("~%E~", m_BaseMstr.SelectedEncounterID);
                                //// replace the treatment id place holder ~%T~
                                //strToolbarItm = strToolbarItm.Replace("~%T~", m_BaseMstr.SelectedTreatmentID.ToString());

                                strToolbarItm = strToolbarItm.Replace("~%E~", String.Empty);
                                // replace the treatment id place holder ~%T~
                                strToolbarItm = strToolbarItm.Replace("~%T~", String.Empty);
                            }
                        }
                        else
                        {
                            strToolbarItm = String.Empty;
                        }

                        //if (bCheckPatLock && m_BaseMstr.IsPatientLocked)
                        //{
                        //    strToolbarItm = String.Empty;
                        //}

                        //check for TIU
                        if (bTIU && bIgnoreOnTIU)
                        {
                            strToolbarItm = String.Empty;
                        }

                        strHTML += strToolbarItm;
                    }
                }
            }
        }

        return strHTML;
    }

    /// <summary>
    /// get all menu items
    /// </summary>
    /// <returns></returns>
    protected DataSet GetAllMenuItemsDS()
    {
        //status info
        long lStatusCode = 0;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList pList = new CDataParameterList(m_BaseMstr.ASPSessionID, m_BaseMstr.ClientIP, m_BaseMstr.FXUserID);

        pList.AddInputParameter("pi_nAppID", m_AppID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(m_BaseMstr.DBConn,
                                           "PCK_APP_MENU2.GetAllMenuItemsRS",
                                            pList,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        m_BaseMstr.StatusCode = lStatusCode;
        m_BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Renders the toolbar to the passed on panel
    /// </summary>
    /// <param name="pnlParent"></param>
    public void RenderToolbar(ext.Panel pnlParent)
    {
        m_AllMenuItems = GetAllMenuItemsDS();

        DataSet ds = this.GetRootLevelItemsDS();

        ext.Toolbar tb = new ext.Toolbar();

        if (ds != null)
        {
            foreach (DataTable dt in ds.Tables)
            {
                foreach (DataRow dr in dt.Rows)
                {

                    //item type
                    long lItemType = 1;
                    if (!dr.IsNull("ITEM_TYPE"))
                    {
                        lItemType = Convert.ToInt32(dr["ITEM_TYPE"]);
                    }

                    if (lItemType == 1)
                    {
                        //create the menu buttons
                        ext.Button btn = new ext.Button();

                        //Item ID
                        long lItemID = -1;
                        if (!dr.IsNull("ITEM_ID"))
                        {
                            lItemID = Convert.ToInt32(dr["ITEM_ID"]);
                        }

                        //identifier
                        if (!dr.IsNull("IDENTIFIER"))
                        {
                            btn.ID = dr["IDENTIFIER"].ToString();
                            btn.IDMode = ext.IDMode.Static;
                        }

                        //text
                        /*if (!dr.IsNull("ITEM_TITLE"))
                        {
                            btn.Text = dr["ITEM_TITLE"].ToString();
                        }*/

                        if (!dr.IsNull("TITLE"))
                        {
                            btn.Text = dr["TITLE"].ToString();
                        }

                        //icon
                        if (!dr.IsNull("ICON_CLS"))
                        {
                            btn.IconCls = dr["ICON_CLS"].ToString();
                        }

                        if (!dr.IsNull("ICON_FILE"))
                        {
                            //btn.IconUrl = this.IconsPath + dr["ICON_FILE"].ToString();
                            btn.IconUrl = this.strAppPath + dr["ICON_FILE"].ToString();
                        }

                        //href
                        string strHREF = CDataUtils2.GetDSStringValue(dr, "HREF");
                        if (!String.IsNullOrEmpty(strHREF))
                        {                            
                            //check for href target
                            string strTarget = "_self";
                            if (!dr.IsNull("HREF_TARGET"))
                            {
                                strTarget = dr["HREF_TARGET"].ToString();
                            }
                            btn.HrefTarget = strTarget;

                            string strH = strMenuPath + dr["HREF"].ToString();

                            if (CDataUtils2.GetDSLongValue(dr, "CLOSES_PATIENT") > 0)
                            {
                                if (!String.IsNullOrEmpty(m_BaseMstr.SelectedPatientID))
                                {
                                    btn.OnClientClick = "if(appmenu.confirmClosePatient()){window.location.href='" + strH + "';}";
                                }
                                else
                                {
                                    btn.Href = strH;
                                }
                            }
                            else
                            {
                                btn.Href = strH;
                            }

                            Ext.Net.ConfigItem itm = new ext.ConfigItem("CLOSES_PATIENT", "CLOSES_PATIENT");
                            btn.CustomConfig.Add(itm);
                        }
                        else
                        {
                            string strHandler = CDataUtils2.GetDSStringValue(dr, "HANDLER");
                            //handler
                            if (!String.IsNullOrEmpty(strHandler))
                            {
                                // btn.Listeners.Click.AddScript(dr["HANDLER"].ToString());
                                btn.Listeners.Click.Handler = dr["HANDLER"].ToString();
                            }
                        }

                        //GET CHILD ITEMS
                        RenderChildMenuItems(btn, lItemID);

                        //add button to the toolbar
                        tb.Items.Add(btn);

                    }
                    else if (lItemType == 2)
                    {
                        //create new toolbar separator
                        ext.ToolbarSeparator btn = new ext.ToolbarSeparator();

                        //add button to the toolbar
                        tb.Items.Add(btn);
                    }
                    else if (lItemType == 4)
                    {
                        //create new toolbar fill
                        ext.ToolbarFill btn = new ext.ToolbarFill();

                        //add button to the toolbar
                        tb.Items.Add(btn);
                    }
                }
            }

            if (tb.Items.Count > 0)
            {
                pnlParent.TopBar.Add(tb);
            }
        }
    }

    /// <summary>
    ///  renders the child menu items
    /// </summary>
    /// <param name="btnParent"></param>
    /// <param name="lParentItemID"></param>
    protected void RenderChildMenuItems(object btnParent, long lParentItemID)
    {
        string strObjectType = btnParent.GetType().ToString();

        List<ext.MenuItem> lst = this.GetChildMenuItems(lParentItemID);
        if (lst.Count > 0)
        {
            ext.Menu newMenu = new ext.Menu();
            foreach (var m in lst)
            {
                long lItemID = -1;
                if (m.Attributes["ITEM_ID"] != null)
                {
                    lItemID = Convert.ToInt32(m.Attributes["ITEM_ID"]);
                }

                RenderChildMenuItems(m, lItemID);
                newMenu.Items.Add(m);
            }

            if (strObjectType.IndexOf("MenuItem") >= 0)
            {
                ((ext.MenuItem)btnParent).Menu.Add(newMenu);
            }
            else if (strObjectType.IndexOf("Button") >= 0)
            {
                ((ext.Button)btnParent).Menu.Add(newMenu);
            }
        }
    }

    /// <summary>
    /// gets a list of menu child items
    /// </summary>
    /// <param name="lParentItemID"></param>
    /// <returns></returns>
    protected List<ext.MenuItem> GetChildMenuItems(long lParentItemID)
    {
        DataSet ds = this.GetMenuChildItemsDS(lParentItemID);

        List<ext.MenuItem> lstItems = new List<ext.MenuItem>();

        if (ds != null)
        {
            if (ds.Tables[0].Rows.Count > 0)
            {
                foreach (DataTable dt in ds.Tables)
                {
                    foreach (DataRow dr in dt.Rows)
                    {
                        //show the option?
                        bool bShow = true;

                        //if patient required, make sure we have one looked up
                        long lPatRequired = CDataUtils2.GetDSLongValue(dr, "REQUIRES_PATIENT");
                        if (lPatRequired > 0)
                        {
                            if (m_BaseMstr.SelectedPatientID.Length < 1)
                            {
                                bShow = false;
                            }
                        }


                        if (bShow)
                        {
                            //item type
                            long lItemType = 1;
                            if (!dr.IsNull("ITEM_TYPE"))
                            {
                                lItemType = Convert.ToInt32(dr["ITEM_TYPE"]);
                            }

                            if (lItemType == 1)
                            {
                                ext.MenuItem btn = new ext.MenuItem();

                                //Item ID
                                long lItemID = -1;
                                if (!dr.IsNull("ITEM_ID"))
                                {
                                    lItemID = Convert.ToInt32(dr["ITEM_ID"]);
                                }

                                //text
                                /*if (!dr.IsNull("ITEM_TITLE"))
                                {
                                    btn.Text = dr["ITEM_TITLE"].ToString();
                                }*/

                                if (!dr.IsNull("TITLE"))
                                {
                                    btn.Text = dr["TITLE"].ToString();
                                }

                                //icon
                                if (!dr.IsNull("ICON_CLS"))
                                {
                                    btn.IconCls = dr["ICON_CLS"].ToString();
                                }

                                if (!dr.IsNull("ICON_FILE"))
                                {
                                    btn.IconUrl = dr["ICON_FILE"].ToString();
                                }

                                //href
                                if (!dr.IsNull("HREF"))
                                {
                                    //check for href target
                                    string strTarget = "_self";
                                    if (!dr.IsNull("HREF_TARGET"))
                                    {
                                        strTarget = dr["HREF_TARGET"].ToString();
                                    }
                                    btn.HrefTarget = strTarget;

                                    string strH = strMenuPath + dr["HREF"].ToString();
                                    if (CDataUtils2.GetDSLongValue(dr, "CLOSES_PATIENT") > 0)
                                    {
                                        if (!String.IsNullOrEmpty(m_BaseMstr.SelectedPatientID))
                                        {
                                            btn.OnClientClick = "if(appmenu.confirmClosePatient()){window.location.href='" + strH + "';}";
                                        }
                                        else
                                        {
                                            btn.Href = strH;
                                        }
                                    }
                                    else
                                    {
                                        btn.Href = strH;
                                    }

                                    Ext.Net.ConfigItem itm = new ext.ConfigItem("CLOSES_PATIENT", "CLOSES_PATIENT");
                                    btn.CustomConfig.Add(itm);
                                }
                                else
                                {
                                    //handler
                                    if (!dr.IsNull("HANDLER"))
                                    {
                                        //btn.Listeners.Click.AddScript(dr["HANDLER"].ToString());
                                        btn.Listeners.Click.Handler = dr["HANDLER"].ToString();
                                    }
                                }

                                btn.Attributes.Add("ITEM_ID", dr["ITEM_ID"].ToString());

                                //add menu item
                                lstItems.Add(btn);
                            }
                        }
                    }
                }
            }
        }
        return lstItems;
    }

}